#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'
require 'watir-scroll'
require 'date'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative 'request_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/request_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'



describe '[Story#VAR-4635: Enter Request Details]
         [Story#VAR-4638: VAR Request Limit Integration with Utility]
         [Story#VAR-4997: Express Care Request: Submit or Cancel Request]
         [Story#VAR-4636: Express Care Request - View Request Details]'  do |time1, time2|
  include OracleUtility
  include DateUtility
  include DriverUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_request = NewAppointmentRequest.new(@driver)
    @detail = RequestAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)

    @@today = getDateNthDaysFromNow(0, "%m/%d/%Y")


    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("expressCareReason", "var-utility", "expressCareReason.json", @db)
    #oracle
    @patientID = "1006088937V099668"
    @patientID2 = "1113138327"
    deletePatientData(@patientID)
    deletePatientData(@patientID2)

    @@facilityName ="BOSTON HCS VAMC"
    @@char250 = "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50" + "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50" + "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50" + "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50"  + "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50"
    @@new_message_50 = "01234567890123456789012345678901234567890123456789"
    @common.loginEndsOnHome(pw_redacted)
    @common.selectAddAppointmentButton("VA")
    @new_request.type_of_care_element.when_visible(TIME_OUT_LIMIT)
    @new_request.selectTypeOfCare(EXPRESS_CARE)
    @new_request.selectState("523")
    @common.waitWhileSpinnerPresent()
    @new_request.selectLocation("523")
    @common.waitWhileSpinnerPresent()
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-4949|TC#VAR-4950: Test New Type of Care - Express Care' do

    it "Express Care is selected, the Scheduling Method is defaulted to 'Submit a Request to VA Scheduler'" do
      expect(@new_request.scheduling_method_radio_elements[1].value).to eq("clerk")
      expect(@new_request.scheduling_method_radio_elements[1].enabled?).to eq(true)
      expect(@new_request.scheduling_method_radio_elements[1].selected?).to eq(true)
      expect(@new_request.request_details_legend).to eq("Request Details - #{EXPRESS_CARE}")
    end

   it "Request Details,  Reason For Visit" do
     @common.waitWhileSpinnerPresent
     @new_request.reason_for_visit_element.when_visible(TIME_OUT_LIMIT)

     expected_content =[\
                        "Express Care visits are available only for certain cases.",
                        "* Reason for Visit",
                        "Select",
                        "Allergies",
                        "Cold Symptoms",
                        "Ear Problem",
                        "Fever",
                        "Headache",
                        "Itching",
                        "Joint Pain",
                        "Muscle Pain",
                        "Rash",
                        "Sinus Concerns",
                        "Sleep Issues",
                        "Stomach/Gastrointestinal Issues",
                        "Other"
     ]

     actual_content = @new_request.request_details_section.split("\n")
     compareContents(expected_content, actual_content)
   end

    it "Verify Reason for Visit Field has default value of 'Select'" do

     expect(@new_request.reason_for_visit).to eq("Select")
    end

    it "Verify Reason for Visit Field is required" do

     @new_request.clickSubmitRequest
     verifyErrorMessage("Reason for Visit field is required.")
    end

    it "Verify Max Character length for reason for visit 'Other'" do

     @new_request.reason_for_visit = "Other"
     @new_request.reason_for_visit_element.fire_event('onblur')
     @new_request.other_reason_for_visit_element.when_visible(TIME_OUT_LIMIT)
     @new_request.other_reason_for_visit = "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50" + "1234"
     expect(@new_request.other_reason_for_visit).to eq("MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50")
     expect(@new_request.other_reason_for_visit.length).to eq(50)
     #workaround
   end

   it "Additional info - 250 characters remaining default message" do
     @new_request.other_reason_for_visit_element.click
     expect(@new_request.other_reason_for_visit).to eq("MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50")
     expect(@new_request. additional_info_message_counter).to eq("250 characters remaining")
   end

    it "Additional info - 250 characters verify remaining character count to 0" do

     @new_request.additional_information = @@char250
     expect(@new_request.additional_information).to eq(@@char250)
     expect(@new_request. additional_info_message_counter).to eq("0 characters remaining")
    end

    it "Additional info - 250 characters verify length" do

     char260 = @@char250 + "0123456789"
     @new_request.additional_information = char260
     expect(@new_request.additional_information).to eq(@@char250)
     expect(@new_request.additional_information_element.attribute("placeholder")).to eq("Provide any additional details regarding your reason for requesting this visit.")

   end

    it "Communicating with a Scheduling Clerk About this Reqeust" do
      expected_content =[\
                        "Communicating with a Scheduling Clerk About this Request",
                        "Please provide your phone information in case we need to contact you.",
                        "If you would like to talk with VA, you may ask a clerk to call you, or you may message a clerk through this app.",
                        "* Phone:",
                        "Phone field is required.",
                        "* Verify Phone:",
                        "Verify Phone field is required.",
                        "* Best Times for VA to Call:",
                        "Morning",
                        "Afternoon",
                        "Evening",
                        "Best Times for VA to Call field is required.",
                        "Would you like the VA to call you regarding this request?",
                        "Yes",
                        "No"
                      ]

      actual_content = @new_request.communicating_section.split("\n")
      compareContents(expected_content, actual_content)
    end

    it "Phone, Best Time to call defaults" do
      expect(@new_request.phoneNumber_element.visible?).to eq(true)
      expect(@new_request.verifyPhoneNumber_element.visible?).to eq(true)
      expect(@new_request.bestTimeToCall_morning_element.visible?).to eq(true)
    end

    it "Phone, Best Time to call required error message" do

      @new_request.clickSubmitRequest
      verifyErrorMessage("Phone field is required.")
      verifyErrorMessage("Verify Phone field is required.")
    end

    it "Verify auto format phone field" do

      @new_request.phoneNumber = "7032223333"
      @new_request.phoneNumber_element.fire_event('onblur')
      expect(@new_request.phoneNumber).to eq("(703) 222-3333")
    end

    it "Verify auto format phone field for abc" do
      @new_request.phoneNumber = "111Abc1111111"
      @new_request.phoneNumber_element.fire_event('onblur')
      expect(@new_request.phoneNumber).to eq("(111) 111-1111")
    end

    it "Please enter a valid US Phone number" do

      button_element = @driver.button(:id => 'schedule-appointment-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      verifyErrorMessage("Please enter a valid US Phone number.")
    end

    it "The phone numbers do not match." do

      @new_request.phoneNumber = "7032223333"
      @new_request.phoneNumber_element.fire_event('onblur')
      @new_request.verifyPhoneNumber = "1112223333"
      @new_request.verifyPhoneNumber_element.fire_event('onblur')
      @new_request.clickSubmitRequest
      verifyErrorMessage("The phone numbers do not match.")
    end

    it "Best Times for VA to Call field is required." do

      @new_request.verifyPhoneNumber = "7032223333"
      @new_request.verifyPhoneNumber_element.fire_event('onblur')
      @new_request.clickSubmitRequest
      verifyErrorMessage("Best Times for VA to Call field is required.")

    end

    it "Revise best time to call options" do
      @new_request.check_bestTimeToCall_morning
      @new_request.check_bestTimeToCall_afternoon
      @new_request.check_bestTimeToCall_evening

      @new_request.uncheck_bestTimeToCall_afternoon
      @new_request.uncheck_bestTimeToCall_evening

      expect(@new_request.bestTimeToCall_morning_checked?).to eq(true)
      expect(@new_request.bestTimeToCall_afternoon_checked?).to eq(false)
      expect(@new_request.bestTimeToCall_evening_checked?).to eq(false)

    end

    it "VA to call reagrding this request default selection" do
      expect(@new_request.requestedPhoneCall_selected?).to eq("false")
    end

    it "VA to call reagrding this request default selection select Yes" do

      @new_request.requestedPhoneCall_yes_element.click
      expect(@new_request.requestedPhoneCall_selected?).to eq("true")
    end

    it "VA to call reagrding this request default selection select No" do

      @new_request.requestedPhoneCall_no_element.click
      expect(@new_request.requestedPhoneCall_selected?).to eq("false")
    end

    it "VA to call reagrding this request default selection select Yes" do

      @new_request.requestedPhoneCall_yes_element.click
      expect(@new_request.requestedPhoneCall_selected?).to eq("true")
    end

    it "Message a Scheduling Clerk defaults" do
      expect(@new_request.message_header).to eq("Message a Scheduling Clerk")
      expect(@new_request.new_message_element.attribute("placeholder")).to eq("Messages (100 characters max) should not be used for cancelling an appointment or for clinical questions that may need provider attention.")
      expect(@new_request.message_counter).to eq("100 characters remaining")
    end

    it "Message a Scheduling Clerk 100 character limit coount update to 50" do

      @new_request.new_message = @@new_message_50
      expect(@new_request.message_counter).to eq("50 characters remaining")
    end

    it "Message a Scheduling Clerk 100 character limit coount update to 0" do
      @new_request.new_message = @@new_message_50 + @@new_message_50
      expect(@new_request.new_message).to eq(@@new_message_50 + @@new_message_50)
      expect(@new_request.message_counter).to eq("0 characters remaining")
    end

    it "Message a Scheduling Clerk 100 character limit, no extra characters accepted" do

      @new_request.new_message = @@new_message_50 + @@new_message_50 + "!!@#!@#!@#%^^"
      expect(@new_request.new_message).to eq(@@new_message_50 + @@new_message_50)
    end

    it "Should verify 0 characters remaining message for messaging a scheduling clerk" do
      @new_request.new_message_element.fire_event('onblur')
      expect(@new_request.message_counter).to eq("0 characters remaining")
    end

    it "Notification Settings" do
      expected_content =[\
                        "Notification Settings",
                        "Express Care visits require an email address so that we may email or text you about your care visit.",
                        "Please confirm your notification contact information before submitting this request.",
                        "* Email:"
      ]

      actual_content =  @new_request.notification_section.split("\n")
      compareContents(expected_content, actual_content)
    end

    it "Email field is required" do
      @new_request.clickSubmitRequest
      verifyErrorMessage("Email field is required.")
    end

    it "Provide Email Address" do
      @new_request.email = "meera.cho@accenturefederal.com"
      @new_request.email_element.fire_event('onblur')
      expect(@new_request.email).to eq("meera.cho@accenturefederal.com")

    end

  end

  context "AC#VAR-5192|TC#VAR-5193: Test Express Care Request: Submit or Cancel" do
    it "Submit Request and Cancel Button text" do
      expect(@new_request.schedule_appointment_element.text).to eq("Submit Request")
      expect(@new_request.cancel_element.text).to eq("Cancel")
    end

    it "Submit Request Details" do

      @new_request.clickSubmitRequest
      time1 = Time.now.strftime("%H:%M")
      @common.waitWhileSpinnerPresent
      @detail.status_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.has_expected_title?).to eq(true)
      expect(@detail.status_element.text).to eq("Status: Submitted")
      expect(@detail.provide_feedback_link_element.text).to eq("Provide feedback on this submission.")
      expect(@detail.status_last_updated_element.text).to include("Updated: " +  @@today)
      expect(@detail.status_desc_element.text).to eq("View status updates for this request under the \"Requests\" section of the Home page. Once scheduled, the resulting appointment will be available in the VA Video Appointment app.")

    end

    it "Click Video Visit, verify reroute message and return option" do
      @detail.video_appointment_link_element.click
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq("Confirmation")
      expect(@modal.content).to eq("You are about to leave the VA Appointments app. Select CONTINUE to proceed to the link information selected, or select RETURN to return to the VA Appointments app.")
      expect(@modal.buttons_elements[1].text).to eq("Return")
    end

    it "Click Video Visit, verify reroute message and continue option" do
      @modal.buttons_elements[1].click
      @detail.video_appointment_link_element.click
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq("Confirmation")
      expect(@modal.content).to eq("You are about to leave the VA Appointments app. Select CONTINUE to proceed to the link information selected, or select RETURN to return to the VA Appointments app.")
      expect(@modal.buttons_elements[0].text).to eq("Continue")
    end

    it "Verify request Details Status" do
      @modal.buttons_elements[0].click
      switchWindowToWindowHandleFirst()
      expect(@detail.back_label).to eq("Appointments/Requests")
      expect(@detail.back_btn_element.visible?).to eq(true)
      expect(@detail.back_btn_element.attribute("aria-label")).to eq("Return to Appointments and Requests")
      expect(@detail.status_element.text).to eq("Status: Submitted")
      expect(@detail.provide_feedback_link_element.text).to eq("Provide feedback on this submission.")
      expect(@detail.status_last_updated_element.text).to include("Updated: " + @@today)
      expect(@detail.status_desc_element.text).to eq("View status updates for this request under the \"Requests\" section of the Home page. Once scheduled, the resulting appointment will be available in the VA Video Appointment app.")
    end

    it "Verify request Details Location, Type of Care and contact information" do

      char250 = "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50" + "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50" + "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50" + "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50"  + "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50"

      expected_details = [\
        "Request Details",
        "Submitted: " + @@today + " @ " + time1  + " Location: #{@@facilityName}" + " Type of Care: #{EXPRESS_CARE}" + " Preference: Call before booking appointment" + " Reason for Visit: Other" + " Other Reason for Visit: MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50" + " Additional Information: " + char250,
        "Your Contact Information",
        "Phone (703) 222-3333 Best Times for VA to Call Morning"
      ]
      actual_text = @detail.request_details_group_element.text.split("\n")
      compareContents(expected_details, actual_text)
    end

    it "Verify Message a scheduing clerk section details" do
      expected_communicating_with_clerk= [\
          "Message a Scheduling Clerk",
          "You may send up to two (2) messages while this request is in Submitted status. If you need additional information, please call your local VA Medical Center"
      ]
      actual_text = @detail.communicate_with_clerk_group_element.text.split("\n")
      expected_communicating_with_clerk.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i]).to eq(expectedScreenRow)

      end

    end

    it "Cancel Request confirmation dialogue details and No option" do
      @detail.back_btn
      @common.waitWhileSpinnerPresent
      @common.selectAddAppointmentButton("VA")
      @new_request.selectTypeOfCare(EXPRESS_CARE)
      @new_request.selectState("523")
      @new_request.selectLocation("523")
      @new_request.cancel_element.when_visible(TIME_OUT_LIMIT)
      @new_request.cancel
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq("Cancel Confirmation")
      expect(@modal.content).to eq("Are you sure you want to cancel this request?")
      expect(@modal.buttons_elements[1].text).to eq("No")
    end

    it "Cancel Request confirmation dialogue displayed" do
      @modal.buttons_elements[1].click
      expect(@new_request.cancel_element.visible?).to eq(true)
    end
    it "Cancel Request confirmation dialogue details and Yes option" do
      @new_request.cancel
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq("Cancel Confirmation")
      expect(@modal.buttons_elements[0].text).to eq("Yes")
    end

    it "Successfully cancel creating a request" do
      @modal.buttons_elements[0].click
      @common.waitWhileSpinnerPresent
      Watir::Wait.until { @landing_appointments.add_top_btn_element.present? }
      @landing_appointments.add_top_btn_element.when_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.add_top_btn_element.present?).to eq(true)

    end
  end

  context "AC#VAR-5153|TC#VAR-5154:  Validate Integration of VAR RequestLimit with Utility" do

    it "Type of Care drop down order matches utility order (e.g. Primary Care is shown first followed by other types of care listed in alphabetical order)" do
      @common.selectAddAppointmentButton("VA")
      @new_request.step_1_type_of_care_element.when_visible(TIME_OUT_LIMIT)
      expect(@new_request.type_of_care_options).to eq(["Select", PRIMARY_CARE, AUDIOLOGY, EXPRESS_CARE, OPTOMETRY, MENTAL_HEALTH ])

    end

    it "submit an express care request" do
      @new_request.selectTypeOfCare(EXPRESS_CARE)
      @new_request.selectState("523")
      @common.waitWhileSpinnerPresent()
      @new_request.selectLocation("523")
      @new_request.addExpressCare
      @detail.status_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.has_expected_title?).to eq(true)
      expect(@detail.status_element.text).to eq("Status: Submitted")
      expect(@detail.status_last_updated_element.text).to include("Updated: " + @@today)
      expect(@detail.provide_feedback_link_element.text).to eq("Provide feedback on this submission.")
    end

    it "Limit of the submitted requests has been reached" do
      time2 = Time.now.strftime("%H:%M")
      @detail.back_btn
      @common.waitWhileSpinnerPresent
      @common.selectAddAppointmentButton("VA")
      @new_request.selectTypeOfCare(EXPRESS_CARE)
      @new_request.selectState("523")
      @new_request.selectLocation("523")
      @common.waitWhileSpinnerPresent()

      expected_content =[\
                        "Step 4: Scheduling Method",
                        "The location you selected supports the following scheduling methods:",
                        "* Select a scheduling method:",
                        "Schedule Myself",
                        "This method is not available for the type of care you selected.",
                        "Submit a Request to VA Scheduler",
                        "You have reached the limit of 2 Express Care request(s).",
                        "In order to proceed, please cancel a pending request, or wait for the VA to process a request."
      ]

      actual_content = @new_request.scheduling_method_section.split("\n")
      compareContents(expected_content, actual_content)

    end
  end

  context "AC#VAR-5198|TC#VAR-5199:  Validate Express Care Request - View Request Details , Cancel Request" do
    it "View Request Details Header" do
      @new_request.back_btn
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      @modal.buttons_elements[0].click
      expect(@landing_appointments.primary_header).to eq("Appointments/Requests")
    end

    it "Verify requests status in list" do
      Watir::Wait.until {@landing_appointments.request_table_list_elements.length > 1}
      request_details = @landing_appointments.request_table_list_elements[0]
      request_details.scroll.to :top
      Watir::Wait.until {@landing_appointments.getRequestTextForRowCol(2,2) == "Submitted"}
      expect(@landing_appointments.getRequestTextForRowCol(1,2)).to eq("Submitted")
      expect(@landing_appointments.getRequestTextForRowCol(2,2)).to eq("Submitted")
    end

    it "Verify Submitted request details status and instructional text" do
      @landing_appointments.request_table_list_elements[0].click
      @detail.status_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.has_expected_title?).to eq(true)
      expect(@detail.status_element.text).to eq("Status: Submitted")
      expect(@detail.status_last_updated_element.text).to include("Updated: " + @@today)
      expect(@detail.status_desc_element.text).to eq("View status updates for this request under the \"Requests\" section of the Home page. Once scheduled, the resulting appointment will be available in the VA Video Appointment app.")
    end

    it "Verify Submitted request details" do
      expected_details = [\
        "Request Details",
        "Submitted: " + @@today + " @ " + time2  + " Location: BOSTON HCS VAMC" + " Type of Care: Express Care" + " Preference: Call before booking appointment" + " Reason for Visit: Ear Problem" + " Additional Information: Adding 2nd Express Care Request",
        "Your Contact Information",
        "Phone (703) 222-3333 Best Times for VA to Call Afternoon Morning"

      ]
      actual_text = @detail.request_details_group_element.text.split("\n")
      compareContents(expected_details, actual_text)


    end

    it "Verify Message a clerk section" do
      expected_communicating_with_clerk= [\
          "Message a Scheduling Clerk",
          "You may send up to two (2) messages while this request is in Submitted status. If you need additional information, please call your local VA Medical Center"
      ]
      actual_text = @detail.communicate_with_clerk_group_element.text.split("\n")
      expected_communicating_with_clerk.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i]).to eq(expectedScreenRow)

      end
    end

    it "Cancel Request button present" do
      expect(@detail.cancel_btn_element.text).to eq("Cancel Request")
    end

    it "Cancel request confirmation dialogue details" do

      @detail.cancel_btn_element.click
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq("Confirmation")
      expect(@modal.content_element.text).to eq("Are you sure you want to cancel this request?\nSelect Yes to cancel, No to return to the Request details page.")
      expect(@modal.buttons_elements[0].text).to eq("Yes")
      expect(@modal.buttons_elements[1].text).to eq("No")
    end

    it "Return back to details from Cancel" do
      @modal.buttons_elements[1].click
      @detail.request_details_group_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.has_expected_title?).to eq(true)
  end

  it "Successfully cancel request" do
      @detail.cancel_btn_element.click
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      @modal.buttons_elements[0].click
      @detail.status_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@detail.status_element.text == "Status: Cancelled"}
      expect(@detail.status_element.text).to eq("Status: Cancelled")
      expect(@detail.status_desc_element.text).to eq("You have successfully cancelled this request.")
      expect(@detail.status_last_updated_element.text).to include("Updated: " + @@today)
  end

    it "return back to list from cancelled request details page" do

      button_element = @driver.button(:id => 'back-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      expect(@landing_appointments.primary_header).to eq("Appointments/Requests")
    end

    it "Verify Cancelled status in request list" do
      request_details = @landing_appointments.request_table_list_elements[0]
      request_details.scroll.to :top
      Watir::Wait.until {@landing_appointments.request_table_list_elements.length > 1}
      Watir::Wait.until {@landing_appointments.getRequestTextForRowCol(2,2) == "Submitted"}
      expect(@landing_appointments.getRequestTextForRowCol(1,2)).to eq("Cancelled")
      expect(@landing_appointments.getRequestTextForRowCol(2,2)).to eq("Submitted")
    end

  end
end







